﻿using System.IdentityModel.Tokens;
using System.IO;
using System.Net;
using System.ServiceModel;

using Microsoft.IdentityModel.Protocols.WSTrust;
using Microsoft.IdentityModel.SecurityTokenService;
using Newtonsoft.Json;

using IDI.Demo.OrderPlacementServiceReference1;

namespace IDI.Demo
{
    public static class Utilities
    {
        #region CreateSecurityToken

        public static SecurityToken CreateSecurityToken(string environmentName)
        {
            WSTrustChannelFactory trustFactory = new WSTrustChannelFactory("SecurityTokenServiceIssuePort");

            //Format should be ENVIRONMENT\\DOMAIN\\USERNAME
            trustFactory.Credentials.UserName.UserName = string.Format("{0}\\IDI\\ws_user", environmentName);
            trustFactory.Credentials.UserName.Password = "p@ssw0rd";

            WSTrustChannel trustChannel = (WSTrustChannel)trustFactory.CreateChannel();
            RequestSecurityToken rst = new RequestSecurityToken(RequestTypes.Issue);
            rst.AppliesTo = new EndpointAddress("http://idibilling.com/webservices");
            RequestSecurityTokenResponse rstr = null;

            return trustChannel.Issue(rst, out rstr);
        }

        #endregion

        #region CreateCustomerChannel

        public static OrderPlacementServicePortTypeChannel CreateOrderPlacementChannel(SecurityToken securityToken)
        {
            ChannelFactory<OrderPlacementServicePortTypeChannel> factory = new ChannelFactory<OrderPlacementServicePortTypeChannel>("OrderPlacementServicePort");
            factory.ConfigureChannelFactory();
            OrderPlacementServicePortTypeChannel channel = ChannelFactoryOperations.CreateChannelWithIssuedToken<OrderPlacementServicePortTypeChannel>(factory, securityToken);

            return channel;
        }

        #endregion

        #region CreateSWT
        public static string CreateSWT()
        {

            string SecurityServiceLoginURL = "https://api.qaeng.infodirections.com/SecurityToken/1X/OLB_WIRELESS_AUTOMATION/api/login";
            string SWT = "";

            var httpWebRequest = (HttpWebRequest)WebRequest.Create(SecurityServiceLoginURL);
            httpWebRequest.ContentType = "application/json";
            httpWebRequest.Method = "POST";

            using (var streamWriter = new StreamWriter(httpWebRequest.GetRequestStream()))
            {
                WSLogin _loginInformation = new WSLogin();
                _loginInformation.Primary = new LoginInformation() { AppliesTo = "http://idibilling.com/webservices", Password = "p@ssw0rd", Username = "IDI\\ws_user" };
                _loginInformation.Environment = "TEL01_S_STAGE";

                string json = JsonConvert.SerializeObject(_loginInformation);

                streamWriter.Write(json);
                streamWriter.Flush();
                streamWriter.Close();
            }

            var httpResponse = (HttpWebResponse)httpWebRequest.GetResponse();
            using (var streamReader = new StreamReader(httpResponse.GetResponseStream()))
            {
                SWT = streamReader.ReadToEnd();
            }

            return SWT;

        }
        #endregion


        #region SWT Login Objects
        public class WSLogin
        {
            public LoginInformation Primary { get; set; }
            public string Environment { get; set; }
            public LoginInformation ActAs { get; set; }

        }
        public class LoginInformation
        {
            public string AppliesTo { get; set; }
            public string Password { get; set; }
            public string Username { get; set; }
        }
        #endregion
    }
}